/*
 * Decompiled with CFR 0.152.
 */
package de.christophlinder.supa;

import de.christophlinder.supa.ClipboardException;
import de.christophlinder.supa.codecs.CodecException;
import de.christophlinder.supa.codecs.ImageCodec;
import de.christophlinder.supa.codecs.ImageIOCodec;
import de.christophlinder.supa.encodings.Base64Encoding;
import de.christophlinder.supa.encodings.Encoding;
import de.christophlinder.supa.encodings.NullEncoding;
import de.christophlinder.supa.scalers.FitToCanvasScaler;
import de.christophlinder.supa.scalers.OriginalSizeScaler;
import de.christophlinder.supa.scalers.PreviewScaler;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.GregorianCalendar;

public class SupaApplet
extends Applet {
    private static final long serialVersionUID = 1L;
    private boolean trace = false;
    public static final String PARAM_CLICKFORPASTE = "clickforpaste";
    public static final String PARAM_IMAGECODEC = "imagecodec";
    public static final String PARAM_ENCODING = "encoding";
    public static final String PARAM_PREVIEWSCALER = "previewscaler";
    public static final String PARAM_TRACE = "trace";
    public static final String PARAM_PASTE_ON_LOAD = "pasteonload";
    public static final String PARAM_BACKGROUND_COLOR = "backgroundcolor";
    public static final String CODEC_JPG = "jpg";
    public static final String CODEC_PNG = "png";
    public static final String ENCODING_NONE = "none";
    public static final String ENCODING_BASE64 = "base64";
    public static final String SCALER_FIT_TO_CANVAS = "fit to canvas";
    public static final String SCALER_ORIGINAL_SIZE = "original size";
    private boolean clickForPaste;
    private boolean pasteOnLoad;
    private Color backgroundColor;
    private final transient AccessControlContext context = AccessController.getContext();
    private Image image = null;
    private ImageCodec imageCodec;
    private Encoding encoding;
    private PreviewScaler previewScaler;

    protected void trc(String string) {
        if (this.trace) {
            System.out.println("" + new GregorianCalendar().getTimeInMillis() + ": " + string);
        }
    }

    protected ImageCodec getImageCodec() {
        return this.imageCodec;
    }

    public void setImageCodec(ImageCodec imageCodec) {
        this.imageCodec = imageCodec;
    }

    public void setImageCodec(String string) {
        if (CODEC_PNG.equals(string)) {
            this.setImageCodec(new ImageIOCodec(CODEC_PNG));
        } else {
            this.setImageCodec(new ImageIOCodec(CODEC_JPG));
        }
    }

    protected Encoding getEncoding() {
        return this.encoding;
    }

    protected void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    public void setEncoding(String string) {
        if (ENCODING_BASE64.equals(string)) {
            this.trc("setEncoding: base64");
            this.setEncoding(new Base64Encoding());
        } else {
            this.trc("setEncoding: null");
            this.setEncoding(new NullEncoding());
        }
    }

    private Color parseColor(String string, Color color) {
        Color color2 = color;
        if (string != null && !"".equals(string)) {
            try {
                String string2 = string;
                if (string2.startsWith("#")) {
                    string2 = string2.replaceFirst("#", "0x");
                }
                if (!string2.startsWith("0x")) {
                    string2 = "0x" + string2;
                }
                this.trc("parsed color: " + string2);
                color2 = Color.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Could not parse color: " + string);
                System.err.println("Must be in the format #RRGGBB or 0xRRGGBB where each component is in the hex range 00-FF");
            }
        }
        return color2;
    }

    protected void setBackgroundColor(String string) {
        this.backgroundColor = this.parseColor(string, Color.WHITE);
        this.setBackground(this.backgroundColor);
    }

    protected Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean isPasteOnLoad() {
        return this.pasteOnLoad;
    }

    public void setPasteOnLoad(boolean bl) {
        this.pasteOnLoad = bl;
    }

    protected PreviewScaler getPreviewScaler() {
        return this.previewScaler;
    }

    public void setPreviewScaler(PreviewScaler previewScaler) {
        this.previewScaler = previewScaler;
    }

    public void setPreviewScaler(String string) {
        if (SCALER_FIT_TO_CANVAS.equals(string)) {
            this.setPreviewScaler(new FitToCanvasScaler());
        } else {
            this.setPreviewScaler(new OriginalSizeScaler());
        }
    }

    protected Image getClipboardContents() throws ClipboardException {
        this.trc("getClipboardContents() start");
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            this.trc("getData");
            Image image = (Image)clipboard.getData(DataFlavor.imageFlavor);
            this.trc("getClipboardContents end");
            return image;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            throw new ClipboardException(3);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ClipboardException(4);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new ClipboardException(1);
        }
    }

    public int pasteFromClipboard() {
        this.trc("pasteFromClipboard() start");
        Image image = null;
        try {
            this.trc("doPrivileged");
            image = AccessController.doPrivileged(new PrivilegedAction<Image>(){

                @Override
                public Image run() {
                    return SupaApplet.this.getClipboardContents();
                }
            }, this.context);
        }
        catch (ClipboardException clipboardException) {
            this.trc("return error: " + clipboardException.getErrorCode());
            return clipboardException.getErrorCode();
        }
        this.trc("set image");
        if (image != null) {
            this.clear();
            this.image = image;
        }
        this.trc("repaint");
        this.repaint();
        this.trc("pasteFromClipboard() end");
        return 0;
    }

    public void clear() {
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        this.repaint();
    }

    public boolean ping() {
        return true;
    }

    protected byte[] getBytes() throws CodecException {
        if (this.image == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 1);
        bufferedImage.getGraphics().drawImage(this.image, 0, 0, null);
        byte[] byArray = this.imageCodec.encode(bufferedImage);
        this.trc("" + this.encoding);
        return byArray;
    }

    public String getEncodedString() throws CodecException {
        byte[] byArray = this.getBytes();
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = this.encoding.encode(byArray);
        return new String(byArray2);
    }

    public int getImageWidth() {
        if (this.image == null) {
            return 0;
        }
        return this.image.getWidth(null);
    }

    public int getImageHeight() {
        if (this.image == null) {
            return 0;
        }
        return this.image.getHeight(null);
    }

    public void setClickForPaste(boolean bl) {
        this.clickForPaste = bl;
    }

    public boolean isClickForPaste() {
        return this.clickForPaste;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public void start() {
        this.trc("SupaApplet started");
        super.start();
        this.setImageCodec(this.getParameter(PARAM_IMAGECODEC));
        this.setEncoding(this.getParameter(PARAM_ENCODING));
        this.setPreviewScaler(this.getParameter(PARAM_PREVIEWSCALER));
        this.setTrace(SupaApplet.parseBoolean(this.getParameter(PARAM_TRACE), false));
        this.setPasteOnLoad(SupaApplet.parseBoolean(this.getParameter(PARAM_PASTE_ON_LOAD), false));
        this.setBackgroundColor(this.getParameter(PARAM_BACKGROUND_COLOR));
        this.setClickForPaste(SupaApplet.parseBoolean(this.getParameter(PARAM_CLICKFORPASTE), false));
        MouseListener mouseListener = new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                SupaApplet.this.trc("ClickForPaste enabled");
                if (SupaApplet.this.isClickForPaste()) {
                    try {
                        SupaApplet.this.pasteFromClipboard();
                    }
                    catch (ClipboardException clipboardException) {
                        clipboardException.printStackTrace(System.err);
                    }
                }
            }
        };
        this.addMouseListener(mouseListener);
        if (this.isPasteOnLoad()) {
            this.trc("Paste on load enabled");
            this.pasteFromClipboard();
        }
    }

    protected Dimension getPreviewImageSize() {
        Dimension dimension = new Dimension(this.image.getWidth(null), this.image.getHeight(null));
        Dimension dimension2 = new Dimension(this.getWidth(), this.getHeight());
        Dimension dimension3 = this.previewScaler.getNewImageSize(dimension2, dimension);
        return dimension3;
    }

    protected void paintImage(Graphics2D graphics2D) {
        if (this.image != null) {
            Dimension dimension = this.getPreviewImageSize();
            graphics2D.drawImage(this.image, 0, 0, dimension.width, dimension.height, null);
        }
    }

    private static boolean parseBoolean(String string, boolean bl) {
        if (string == null || "".equals(string)) {
            return bl;
        }
        return Boolean.parseBoolean(string);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintImage((Graphics2D)graphics);
    }
}

