/*
 * Decompiled with CFR 0.152.
 */
package de.christophlinder.supa.codecs;

import de.christophlinder.supa.codecs.CodecException;
import de.christophlinder.supa.codecs.ImageCodec;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageIOCodec
implements ImageCodec {
    protected String formatName = "jpg";

    public ImageIOCodec(String string) {
        this.formatName = string;
    }

    public byte[] encode(BufferedImage bufferedImage) throws CodecException {
        if (!ImageIOCodec.isValidFormatName(this.formatName)) {
            throw new CodecException("not a valid format: " + this.formatName);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            ImageIO.setUseCache(false);
            ImageIO.write((RenderedImage)bufferedImage, this.formatName, bufferedOutputStream);
            bufferedOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (SecurityException securityException) {
            throw new CodecException(securityException.getMessage());
        }
        catch (IOException iOException) {
            String string = "";
            for (String string2 : ImageIO.getWriterFileSuffixes()) {
                string = string + (string.length() > 0 ? ", " : "" + string2);
            }
            throw new CodecException(iOException.getMessage() + ", Supported formats: " + string, iOException);
        }
    }

    public static String[] getFormatNames() {
        return ImageIO.getWriterFormatNames();
    }

    public static boolean isValidFormatName(String string) {
        List<String> list = Arrays.asList(ImageIOCodec.getFormatNames());
        System.out.println("wanted format:" + string + ":");
        for (String string2 : list) {
            System.out.println("supported format:" + string2 + ":");
        }
        return list.contains(string);
    }
}

